/************************************************************************/
/*  File name : GnuPGModule.cpp                                         */
/************************************************************************/
/*  Contents  : IR[fBOKɊÂvg^Cv                */
/*                                                                      */
/*  Auther    : Yasuhiro ARAKAWA    Version 0.00    2000.09.12          */
/*                                  Version 0.01    2000.09.14          */
/*                                  Version 0.10    2000.09.27          */
/*                                  Version 0.20    2000.10.03          */
/*                                  Version 0.30    2000.10.08          */
/*                                  Version 0.31    2000.10.19          */
/*                                  Version 0.32    2000.10.26          */
/*                                  Version 1.0.0   2000.11.08          */
/************************************************************************/

/**** Incude Files ****/
#include "GnuPGModule.h"
#include "LogFile.h"

#include <string>
#include <fstream>
using namespace std;

#include "debug.h" //Ōɒ`


/**** Internal Macro ****/


/**** Typedef ****/


/**** Constants ****/
const DWORD CGnuPGModule::m_PipeSize = 32767; //pCṽobt@TCY
const char* const CGnuPGModule::m_DefaultModuleName = "gpg.exe";  //ftHg̃W[
const char* const CGnuPGModule::m_DefaultOption = "--logger-fd 2 --batch --yes --verbose";  //ftHgIvV
    //   --logger-fd 2: Ȍo͂WG[o͂ɂ
    //         --batch: ob`[hŏ
    //           --yes: ₢킹ɑ΂đSāuYesvŎ
    //       --verbose: ڍו\
const char* const CGnuPGModule::m_SignPGPOption = "--force-v3-sigs"; //pPGPΉIvV
    // --force-v3-sigs: Version 3 ŏ (gpg ̃ftHg Version 4)
const char* const CGnuPGModule::m_OpenPGPOption = "--openpgp"; //OpenPGPΉIvV
const char* const CGnuPGModule::m_ThrowKeyIDOption = "--throw-keyid"; //MґΉIvV
const char* const CGnuPGModule::m_RFC1991Option = "--rfc1991"; //RFC1991IvV
const char* const CGnuPGModule::m_MdMD5Option = "--digest-algo MD5"; //bZ[W_CWFXgMD5gIvV
const char* const CGnuPGModule::m_MdSHA1Option = "--digest-algo SHA1"; //bZ[W_CWFXgSHA-1gIvV


/**** Prototyping ****/


/*----------------------------------------------------------------------*/
/* Purpose        : ftHgRXgN^                            */
/* Inputs         : W[ւ̃pX                                  */
/*----------------------------------------------------------------------*/
CGnuPGModule::CGnuPGModule(const char* moduleName)
    : m_hStdoutRead(NULL), m_hStdoutWrite(NULL),
        m_hStderrRead(NULL), m_hStderrWrite(NULL),
        m_hStdinRead(NULL), m_hStdinWrite(NULL),
        m_hProcess(NULL),
        m_bPGPMIME(true), m_bPGPCompatible(true),
        m_bOpenPGP(false), m_bThrowKeyID(false),
        m_bRFC1991(false), m_bMD5(false),
        m_bTextModeSig(false)
{
    if(moduleName==NULL) {
        m_ModuleName = m_DefaultModuleName;
    }
    else {
        m_ModuleName = moduleName;
    }
    m_DefUserID = ""; //ftHg[UID
}

/*----------------------------------------------------------------------*/
/* Purpose        : Í                                          */
/* Inputs         : ÍbZ[Wi[t@Cւ̃pX      */
/*                  ÍΏۃbZ[Wi[t@Cւ̃pX        */
/*                  [AhX(=UserID)Xg                       */
/* Ootput         : Boolearn                                            */
/*----------------------------------------------------------------------*/
bool CGnuPGModule::ExecEncrypt(const char* ascPath, const char* txtPath, vector<string>& addrList)
{
    //
    if(ascPath==NULL || txtPath==NULL || (addrList.size())==0) { //K{p[^Ȃ
        return false;
    }
    m_StdoutBuffer = m_StderrBuffer = ""; //Wo̓obt@NA

    //R}hݒ
    m_CommandStr = "-ea ";
    m_CommandStr += Quotation(string(txtPath));
    //IvVݒ
    m_OptionStr = m_DefaultOption; //ftHg̃IvVZbg
    if(m_bPGPCompatible==true) {
        if(m_bRFC1991==true) {
            m_OptionStr += " ";
            m_OptionStr += m_RFC1991Option;
        }
    }
    else {
        if(m_bOpenPGP==true) {
            m_OptionStr += " ";
            m_OptionStr += m_OpenPGPOption;
        }
        if(m_bThrowKeyID==true) {
            m_OptionStr += " ";
            m_OptionStr += m_ThrowKeyIDOption;
        }
    }
    m_OptionStr += " -o ";
    m_OptionStr += Quotation(string(ascPath));
    for(vector<string>::iterator p=addrList.begin(); p!=addrList.end(); p++) {
        m_OptionStr += " -r ";
        m_OptionStr += Quotation(*p);
    }

    //R}hN
    if((Execute())==false) {
        return false; //Ns
    }

    //vZXI܂ő҂
    WaitforTerminate();

    return true;
}

/*----------------------------------------------------------------------*/
/* Purpose        :                                             */
/* Inputs         : ubNi[t@Cւ̃pX              */
/*                  ΏۃbZ[Wi[t@Cւ̃pX        */
/*                  Ɏg User ID                                  */
/*                  pXt[Y                                        */
/* Ootput         : Boolearn                                            */
/*----------------------------------------------------------------------*/
bool CGnuPGModule::ExecSign(const char* ascPath, const char* txtPath, const char* userID, const char* passPhrase)
{
    //
    if(ascPath==NULL || txtPath==NULL || passPhrase==NULL) { //K{p[^Ȃ
        return false;
    }
    m_StdoutBuffer = m_StderrBuffer = ""; //Wo̓obt@NA

    //R}hݒ
    if(m_bPGPMIME==true) {
        m_CommandStr = "-a "; //p[g𕪗
        if(m_bTextModeSig==true) { //̍ۂɃeLXg[hŏ
            m_CommandStr += "--textmode ";
        }
        m_CommandStr += "--detach-sign "; //p[g𕪗
    }
    else {
        m_CommandStr = "--clearsign "; //NA
    }
    m_CommandStr += Quotation(string(txtPath));
    //IvVݒ
    m_OptionStr = m_DefaultOption; //ftHg̃IvVZbg
    if(m_bPGPCompatible==true) {
        m_OptionStr += " ";
        m_OptionStr += m_SignPGPOption; //PGP݊̂߂̃IvV
        if(m_bRFC1991==true) { //RFC1991ɏ]
            m_OptionStr += " ";
            m_OptionStr += m_RFC1991Option;
        }
    }
    else {
        if(m_bOpenPGP==true) {
            m_OptionStr += " ";
            m_OptionStr += m_OpenPGPOption;
        }
        if(m_bThrowKeyID==true) {
            m_OptionStr += " ";
            m_OptionStr += m_ThrowKeyIDOption;
        }
    }
    m_OptionStr += " ";
    if((m_bPGPCompatible==true || m_bOpenPGP==false) && m_bMD5==true) {
        m_OptionStr += m_MdMD5Option; //ASY(MD5)
    }
    else {
        m_OptionStr += m_MdSHA1Option; //ASY(SHA-1)
    }
    m_OptionStr += " --passphrase-fd 0"; //pXt[Y̓͂W͂ōs
    m_OptionStr += " -o ";
    m_OptionStr += Quotation(string(ascPath)) + " "; //ubN̏o͐
    if(userID!=NULL) {
        m_OptionStr += "-u "; //[UID̎w
        m_OptionStr += Quotation(string(userID)) + " ";
    }
    else if((m_DefUserID.length())>0) {
        m_OptionStr += "--default-key "; //ftHg[UID̎w
        m_OptionStr += Quotation(m_DefUserID) + " ";
    }

    //R}hN
    if((Execute())==false) {
        return false; //Ns
    }
    Sleep(10); //N10msقǑ҂Ă݂

    //pXt[Y
    string sbuf = passPhrase;
    sbuf += "\n";
    Write(sbuf);

    //vZXI܂ő҂
    WaitforTerminate();

    return true;
}

/*----------------------------------------------------------------------*/
/* Purpose        : ÍƏ                                    */
/* Inputs         : EÍubNi[t@Cւ̃pX      */
/*                  EÍΏۃbZ[Wi[t@Cւ̃pX*/
/*                  Ɏg User ID                                  */
/*                  ÍɎg[AhX(=UserID)Xg             */
/*                  pXt[Y                                        */
/* Ootput         : Boolearn                                            */
/*----------------------------------------------------------------------*/
bool CGnuPGModule::ExecEncryptSign(const char* ascPath, const char* txtPath, const char* userID, vector<string>& addrList, const char* passPhrase)
{
    //
    if(ascPath==NULL || txtPath==NULL || (addrList.size())==0 || passPhrase==NULL) { //K{p[^Ȃ
        return false;
    }
    m_StdoutBuffer = m_StderrBuffer = ""; //Wo̓obt@NA

    //R}hݒ
    m_CommandStr = "-esa "; //Í & 
    m_CommandStr += Quotation(string(txtPath));
    //IvVݒ
    m_OptionStr = m_DefaultOption; //ftHg̃IvVZbg
    if(m_bPGPCompatible==true) {
        m_OptionStr += " ";
        m_OptionStr += m_SignPGPOption; //PGP݊̂߂̃IvV
        if(m_bRFC1991==true) { //RFC1991ɏ]
            m_OptionStr += " ";
            m_OptionStr += m_RFC1991Option;
        }
    }
    else {
        if(m_bOpenPGP==true) {
            m_OptionStr += " ";
            m_OptionStr += m_OpenPGPOption;
        }
        if(m_bThrowKeyID==true) {
            m_OptionStr += " ";
            m_OptionStr += m_ThrowKeyIDOption;
        }
    }
    m_OptionStr += " ";
    if((m_bPGPCompatible==true || m_bOpenPGP==false) && m_bMD5==true) {
        m_OptionStr += m_MdMD5Option; //ASY(MD5)
    }
    else {
        m_OptionStr += m_MdSHA1Option; //ASY(SHA-1)
    }
    m_OptionStr += " --passphrase-fd 0 "; //pXt[Y̓͂W͂ōs
    m_OptionStr += "-o ";
    m_OptionStr += Quotation(string(ascPath)) + " "; //EÍpPbg̏o͐
    if(userID!=NULL) {
        m_OptionStr += "-u "; //[UID̎w
        m_OptionStr += Quotation(string(userID));
    }
    else if((m_DefUserID.length())>0) {
        m_OptionStr += "--default-key "; //ftHg[UID̎w
        m_OptionStr += Quotation(m_DefUserID);
    }
    for(vector<string>::iterator p=addrList.begin(); p!=addrList.end(); p++) {
        m_OptionStr += " -r ";
        m_OptionStr += Quotation(*p);
    }

    //R}hN
    if((Execute())==false) {
        return false; //Ns
    }
    Sleep(10); //N10msقǑ҂Ă݂

    //pXt[Y
    string sbuf = passPhrase;
    sbuf += "\n";
    Write(sbuf);

    //vZXI܂ő҂
    WaitforTerminate();

    return true;
}

/*----------------------------------------------------------------------*/
/* Purpose        : J̃GNX|[g                                */
/* Inputs         : Ji[t@Cւ̃pX                    */
/* Ootput         : Boolearn                                            */
/*----------------------------------------------------------------------*/
bool CGnuPGModule::ExecExport(const char* ascPath, const char* userID)
{
    //
    if(ascPath==NULL || userID==NULL) { //K{p[^Ȃ
        return false;
    }
    m_StdoutBuffer = m_StderrBuffer = ""; //Wo̓obt@NA

    //R}hݒ
    m_CommandStr = "-a --export ";
    m_CommandStr += Quotation(string(userID));
    //IvVݒ
    m_OptionStr = m_DefaultOption; //ftHg̃IvVZbg
    if(m_bPGPCompatible==true) {
        m_OptionStr += " ";
        m_OptionStr += m_SignPGPOption; //PGP݊̂߂̃IvV
        if(m_bRFC1991==true) { //RFC1991ɏ]
            m_OptionStr += " ";
            m_OptionStr += m_RFC1991Option;
        }
    }
    else {
        if(m_bOpenPGP==true) {
            m_OptionStr += " ";
            m_OptionStr += m_OpenPGPOption;
        }
    }
    m_OptionStr += " ";
    if((m_bPGPCompatible==true || m_bOpenPGP==false) && m_bMD5==true) {
        m_OptionStr += m_MdMD5Option; //ASY(MD5)
    }
    else {
        m_OptionStr += m_MdSHA1Option; //ASY(SHA-1)
    }
    m_OptionStr += " -o ";
    m_OptionStr += Quotation(string(ascPath)); //bZ[W̏o͐

    //R}hN
    if((Execute())==false) {
        return false; //Ns
    }

    //vZXI܂ő҂
    WaitforTerminate();

    return true;
}

/*----------------------------------------------------------------------*/
/* Purpose        :                                           */
/* Inputs         : ÍbZ[Wi[t@Cւ̃pX          */
/*                  bZ[Wi[t@Cւ̃pX          */
/*                  pXt[Y                                        */
/* Ootput         : Boolearn                                            */
/*----------------------------------------------------------------------*/
bool CGnuPGModule::ExecDecrypt(const char* ascPath, const char* txtPath, const char* passPhrase)
{
    //
    if(ascPath==NULL || txtPath==NULL || passPhrase==NULL) { //K{p[^Ȃ
        return false;
    }
    m_StdoutBuffer = m_StderrBuffer = ""; //Wo̓obt@NA

    //R}hݒ
    m_CommandStr = "-d ";
    m_CommandStr += Quotation(string(ascPath));
    //IvVݒ
    m_OptionStr = m_DefaultOption; //ftHg̃IvVZbg
    m_OptionStr += " --passphrase-fd 0 "; //pXt[Y̓͂W͂ōs
    m_OptionStr += "-o ";
    m_OptionStr += Quotation(string(txtPath)) + " "; //bZ[W̏o͐
    if((m_DefUserID.length())>0) {
        m_OptionStr += "--default-key "; //ftHg[UID̎w
        m_OptionStr += Quotation(m_DefUserID) + " ";
    }

    //R}hN
    if((Execute())==false) {
        return false; //Ns
    }
    Sleep(10); //N10msقǑ҂Ă݂

    //pXt[Y
    string sbuf = passPhrase;
    sbuf += "\n";
    Write(sbuf);

    //vZXI܂ő҂
    WaitforTerminate();

    return true;
}

/*----------------------------------------------------------------------*/
/* Purpose        : ̌                                          */
/* Inputs         : i[t@Cւ̃pX                      */
/*                  폐bZ[Wi[t@Cւ̃pX          */
/* Ootput         : Boolearn                                            */
/*----------------------------------------------------------------------*/
bool CGnuPGModule::ExecVerify(const char* ascPath, const char* txtPath)
{
    //
    if(ascPath==NULL) { //K{p[^Ȃ
        return false;
    }
    m_StdoutBuffer = m_StderrBuffer = ""; //Wo̓obt@NA

    //R}hݒ
    m_CommandStr = "--verify ";
    m_CommandStr += Quotation(string(ascPath));
    if(txtPath!=NULL) {
        m_CommandStr += " ";
        m_CommandStr += Quotation(string(txtPath));
    }
    //IvVݒ
    m_OptionStr = m_DefaultOption; //ftHg̃IvVZbg

    //R}hN
    if((Execute())==false) {
        return false; //Ns
    }

    //vZXI܂ő҂
    WaitforTerminate();

    return true;
}

/*----------------------------------------------------------------------*/
/* Purpose        : J̃C|[g                                  */
/* Inputs         : Ji[t@Cւ̃pX                    */
/* Ootput         : Boolearn                                            */
/*----------------------------------------------------------------------*/
bool CGnuPGModule::ExecImport(const char* ascPath)
{
    //
    if(ascPath==NULL) { //K{p[^Ȃ
        return false;
    }
    m_StdoutBuffer = m_StderrBuffer = ""; //Wo̓obt@NA

    //R}hݒ
    m_CommandStr = "--import ";
    m_CommandStr += Quotation(string(ascPath));
    //IvVݒ
    m_OptionStr = m_DefaultOption; //ftHg̃IvVZbg

    //R}hN
    if((Execute())==false) {
        return false; //Ns
    }

    //vZXI܂ő҂
    WaitforTerminate();

    return true;
}

/*----------------------------------------------------------------------*/
/* Purpose        : GnuPG̃z[fBNg擾                 */
/* Inputs         : Ȃ                                                */
/* Ootput         : GnuPG̃z[fBNg                           */
/*----------------------------------------------------------------------*/
string CGnuPGModule::GetGPGHomeDir(void)
{
    HKEY hKey;
    string dir = "";
    if((RegOpenKeyEx(HKEY_CURRENT_USER, "Software\\GNU\\GnuPG", 0, KEY_QUERY_VALUE, &hKey))!=ERROR_SUCCESS) { //L[Ȃ
        return dir;
    }

    DWORD len;
    if((RegQueryValueEx(hKey, "HomeDir", NULL, NULL, NULL, &len))==ERROR_SUCCESS) {
        if(len>0) {
            len++;
            char* path = new char[len];
            if((RegQueryValueEx(hKey, "HomeDir", NULL, NULL, (LPBYTE)path, &len))==ERROR_SUCCESS) {
                dir = path;
                if(path[strlen(path)-1]!='\\') {
                    dir += "\\";
                }
            }
            delete [] path;
        }
    }
    RegCloseKey(hKey);

    return dir;
}

/*----------------------------------------------------------------------*/
/* Purpose        : CX^X̃Rs[                                */
/* Inputs         : Rs[CX^X                                */
/* Ootput         : Ȃ                                                */
/*----------------------------------------------------------------------*/
void CGnuPGModule::Copy(const CGnuPGModule& org)
{
    //peϐ
    m_ModuleName = org.m_ModuleName;   //W[
    m_OptionStr = org.m_OptionStr;    //NIvV
    m_CommandStr = org.m_CommandStr;   //NR}h
    m_StdoutBuffer = org.m_StdoutBuffer; //Wo̓obt@ (\p)
    m_StderrBuffer = org.m_StderrBuffer; //WG[o̓obt@ (\p)
    //IvV
    m_DefUserID = org.m_DefUserID; //ftHg[UID
    m_bPGPMIME = org.m_bPGPMIME; //PGP/MIMEΉ
    m_bPGPCompatible = org.m_bPGPCompatible; //PGP݊̏EÍs
    m_bOpenPGP = org.m_bOpenPGP; //OpenPGPɏÍs
    m_bThrowKeyID = org.m_bThrowKeyID; //M҂𓽖ɂ
    m_bRFC1991 = org.m_bRFC1991; //RFC1991ɏ]
    m_bMD5 = org.m_bMD5; //MD5gp
    m_bTextModeSig = org.m_bTextModeSig; //̍ۂɃeLXg[hŏ
}

/*----------------------------------------------------------------------*/
/* Purpose        : vZXN                                  */
/* Inputs         : Ȃ                                                */
/* Ootput         : Boolearn                                            */
/*----------------------------------------------------------------------*/
bool CGnuPGModule::Execute(void)
{
    if((IsActive())==true) { // vZXIĂȂ΋I
        Terminate();
    }

    //R}hC̐`
    //char szCom[_MAX_PATH];
    //GetEnvironmentVariable("COMSPEC" , szCom, _MAX_PATH);
    //string cmdline = szCom;
    //cmdline += " /C ";
    //cmdline += Quotation(m_ModuleName);
    string cmdline = m_ModuleName;
    Quotation(cmdline);
    if((m_OptionStr.length())>0) {
        cmdline += " ";
        cmdline += m_OptionStr;
    }
    if((m_CommandStr.length())>0) {
        cmdline += " ";
        cmdline += m_CommandStr;
    }

    //p[^̏
    SECURITY_ATTRIBUTES satt;
    satt.nLength = sizeof(SECURITY_ATTRIBUTES);
    satt.lpSecurityDescriptor = NULL;
    satt.bInheritHandle = TRUE;

    STARTUPINFO si;
    ZeroMemory( &si, sizeof(STARTUPINFO));
    si.cb = sizeof(STARTUPINFO);
    si.dwFlags = STARTF_USESHOWWINDOW | STARTF_USESTDHANDLES;
#ifdef _DEBUG
    si.wShowWindow = SW_MINIMIZE;
    //si.wShowWindow = SW_HIDE;
#else
    si.wShowWindow = SW_HIDE;
#endif
    CreatePipe(&m_hStdinRead,  &m_hStdinWrite,  &satt, m_PipeSize);
    CreatePipe(&m_hStdoutRead, &m_hStdoutWrite, &satt, m_PipeSize);
    CreatePipe(&m_hStderrRead, &m_hStderrWrite, &satt, m_PipeSize);
    si.hStdOutput = m_hStdoutWrite;
    si.hStdError  = m_hStderrWrite;
    si.hStdInput  = m_hStdinRead;

    PROCESS_INFORMATION pi;
    ZeroMemory( &pi, sizeof(PROCESS_INFORMATION));

    //vZX̋N
    g_LogFile.AppendMessage(cmdline.c_str());
    if((CreateProcess(NULL, (LPTSTR)cmdline.c_str(), NULL, NULL, TRUE, CREATE_DEFAULT_ERROR_MODE | HIGH_PRIORITY_CLASS, NULL, NULL, &si, &pi))==FALSE) {
        Sleep(10); // NbVH
        CloseHandle(pi.hThread);
        Terminate(); //p[^߂
        return false;
    }
    else {
        m_hProcess = pi.hThread;
        return true;
    }
}

/*----------------------------------------------------------------------*/
/* Purpose        : vZXI                                  */
/* Inputs         : Ȃ                                                */
/* Ootput         : Ȃ                                                */
/*----------------------------------------------------------------------*/
void CGnuPGModule::Terminate(void)
{
    //vZX̏I
    if(m_hProcess!=NULL) { //쒆
        if((IsActive())==true) { // vZXIĂȂ΋I
            TerminateProcess(m_hProcess, 0);
            WaitForSingleObject(m_hProcess, 1000); //܂1b炢҂Ă݂
        }
        CloseHandle(m_hProcess);
        m_hProcess = NULL;
    }

    //pCv
    if(m_hStdoutRead!=NULL) {
        CloseHandle(m_hStdoutRead);
        m_hStdoutRead = NULL;
    }
    if(m_hStdoutWrite!=NULL) {
        CloseHandle(m_hStdoutWrite);
        m_hStdoutWrite = NULL;
    }
    if(m_hStderrRead!=NULL) {
        CloseHandle(m_hStderrRead);
        m_hStderrRead = NULL;
    }
    if(m_hStderrWrite!=NULL) {
        CloseHandle(m_hStderrWrite);
        m_hStderrWrite = NULL;
    }
    if(m_hStdinRead!=NULL) {
        CloseHandle(m_hStdinRead);
        m_hStdinRead = NULL;
    }
    if(m_hStdinWrite!=NULL) {
        CloseHandle(m_hStdinWrite);
        m_hStdinWrite = NULL;
    }
}

/*----------------------------------------------------------------------*/
/* Purpose        : 񂪋󔒕܂ޏꍇ̓_uNH[eVň͂*/
/* Inputs         :                                               */
/* Ootput         : ϊ                                          */
/*----------------------------------------------------------------------*/
string& CGnuPGModule::Quotation(string& str)
{
    string::size_type len = str.find_first_of(" \t");
    if(len!=string::npos) { //󔒂܂ޕ
        Dequotation(str); //_uNH[eVO
        string sbuf = "\"";
        sbuf += str + "\"";
        str = sbuf;
    }

    return str;
}

/*----------------------------------------------------------------------*/
/* Purpose        : _uNH[eV݂̈͂O                    */
/* Inputs         :                                               */
/* Ootput         : ϊ                                          */
/*----------------------------------------------------------------------*/
string& CGnuPGModule::Dequotation(string& str)
{
    for(;;) {
        string::size_type len = str.length();
        if(len>=2 && str[0]=='\"' && str[len-1]=='\"') {
            str = str.substr(1, len-2);
        }
        else {
            break;
        }
    }

    return str;
}

/*----------------------------------------------------------------------*/
/* Purpose        : vZX͉ғ?                                 */
/* Inputs         : ^CAEg                                    */
/* Ootput         : Boolearn                                            */
/*----------------------------------------------------------------------*/
bool CGnuPGModule::IsActive(DWORD tout)
{
    if(m_hProcess!=NULL) { //쒆
        if(WaitForSingleObject(m_hProcess, tout) != WAIT_OBJECT_0) { //w莞ԑ҂ĂVOiȂ
            return true;
        }
        //DWORD dwStatus;
        //if((GetExitCodeProcess(m_hProcess, &dwStatus))!=FALSE) {
        //    if(dwStatus==STILL_ACTIVE) {
        //        return true;
        //    }
        //}
    }

    return false;
}

/*----------------------------------------------------------------------*/
/* Purpose        : vZXI܂ő҂                          */
/* Inputs         : Ȃ                                                */
/* Ootput         : Boolearn                                            */
/*----------------------------------------------------------------------*/
void CGnuPGModule::WaitforTerminate(void)
{
    IsActive(30000); //ő30b܂ő҂?
    //for(int i=0; i<100 && (IsActive())==true; i++) { //ő10b܂ő҂
    //for(int i=0; i<300 && (IsActive())==true; i++) { //ő30b܂ő҂?
    //    Sleep(100);
    //}
    //Read(m_StdoutBuffer, true);
    Read(m_StderrBuffer, false);
    Terminate();
}

/*----------------------------------------------------------------------*/
/* Purpose        : W͂ւ̓                                    */
/* Inputs         : CvbgbZ[W                                */
/* Ootput         : Boolearn                                            */
/*----------------------------------------------------------------------*/
bool CGnuPGModule::Write(string& inpMsg)
{
    string::size_type len = inpMsg.length();
    if(len<=0) { //̓bZ[WȂ
        return true;
    }
    char* msg = new char[len+1];
    strncpy(msg, inpMsg.c_str(), len);
    msg[len] = '\0';

    char* p = msg;
    DWORD dwRest = len;
    for(;;) {
        DWORD dwLen = 0;
        //if((IsActive())==false) { //vZX͉ғĂȂ
        //    delete [] msg;
        //    return false;
        //}
        if((WriteFile(m_hStdinWrite, p, dwRest, &dwLen, NULL))==FALSE) {
            delete [] msg;
            return false;
        }
        if(dwLen>=dwRest) { //Sď݊
            break;
        }
        p += dwLen;
        dwRest -= dwLen;
    }

    delete [] msg;
    return true;
}

/*----------------------------------------------------------------------*/
/* Purpose        : Wo͂̃bZ[W                            */
/* Inputs         : o̓bZ[Wi[                                */
/* Ootput         : Boolearn                                            */
/*----------------------------------------------------------------------*/
bool CGnuPGModule::Read(string& outpMsg, bool bBlock)
{
    outpMsg = "";

    //pCv̏Ԃ擾
    DWORD dwSize;
    if(bBlock==false) {
        DWORD dwLen;
        if((PeekNamedPipe(m_hStderrRead, NULL, 0, &dwLen, &dwSize, NULL))==FALSE) { //ǂݎ莸s
            return false;
        }
        else if(dwSize<=0) { //Ȃ
            return true;
        }
        dwSize += 8; //strstr() ֐΍?
    }
    else {
        dwSize = m_PipeSize;
    }

    char* buf = new char[dwSize];
    if((ReadFile(m_hStderrRead, buf, dwSize, &dwSize, NULL))==FALSE) {
        delete [] buf;
        return false;
    }
    buf[dwSize] = '\0';
    outpMsg = buf;
    delete [] buf;

#ifdef _DEBUG
    g_LogFile.AppendMessage(outpMsg.c_str());
#endif
    return true;
}

/* Copyright (C) Yasuhiro ARAKAWA  **************************************/
