/************************************************************************/
/*  File name : Decrypt.cpp                                             */
/************************************************************************/
/*  Contents  :  (R[obN֐)                           */
/*                                                                      */
/*  Auther    : Yasuhiro ARAKAWA    Version 0.00    2000.09.12          */
/*                                  Version 0.01    2000.09.14          */
/*                                  Version 0.10    2000.09.27          */
/*                                  Version 0.20    2000.10.03          */
/*                                  Version 0.30    2000.10.08          */
/*                                  Version 1.0.0   2000.11.08          */
/************************************************************************/

/**** Incude Files ****/
#include "BkGnuPGDef.h"
#include "BkGnuPGInfo.h"
#include "CallBacks.h"
#include "MIMEMessage.h"
#include "PassDialog.h"
#include "ViewDialog.h"
#include "LogFile.h"

#include <string>
#include <fstream>
using namespace std;

#include "debug.h" //Ōɒ`


/**** Internal Macro ****/


/**** Typedef ****/


/**** Prototyping ****/
static void ExecDecript(HWND hWnd, LPARAM lParam);
static bool ExecGPG(HWND hWnd, LPARAM lParam, CGnuPGModule::EMODE mode, const char* ascPath, const char* txtPath);
static bool GetMIMEMessage(CMIMEMessage* pTop, CGnuPGModule::EMODE mode, string& ascPath, string& msgPath);
static char* GetMessage(char* lpStr, CGnuPGModule::EMODE& mode, string& ascPath, char* szCharSet);


/*----------------------------------------------------------------------*/
/* Purpose        :  (j[̌Ăяo)                 */
/* Inputs         : --                                                  */
/* Ootput         : Ȃ                                                */
/*----------------------------------------------------------------------*/
void WINAPI Decript(HWND hWnd, LPARAM lParam)
{
    try {
        ExecDecript(hWnd, lParam);
    }
    catch(...) {
        FatalErrorMessage(hWnd, __FILE__, __LINE__); //vIG[eo
    }
}

/*----------------------------------------------------------------------*/
/* Purpose        :                                           */
/* Inputs         : --                                                  */
/* Ootput         : Ȃ                                                */
/*----------------------------------------------------------------------*/
static void ExecDecript(HWND hWnd, LPARAM lParam)
{
    //o̓t@C쐬
    string ascPath = g_Info.m_BkApi.GetTempFileName("asc");
    string msgPath = g_Info.m_BkApi.GetTempFileName("msg");
    RemoveFiles(ascPath);
    RemoveFiles(msgPath);

    //݂̃[wb_𔲂o?
    CMIMEMessage item;
    char* lpSource = g_Info.m_BkApi.GetSource(NULL); //[e (fR[h) o
    if(lpSource==NULL) {
        ErrorMessage(hWnd, IDS_GPG_ERROR);
        return;
    }
    item.FromString(lpSource);
    g_Info.m_BkApi.Free(lpSource); //svȂ̂free

    //PGP/MIMEɊ֘AtB[hT
    CGnuPGModule::EMODE mode = CGnuPGModule::Decript;
    CMIMEMessage* pTop = item.FindCMIMEMessage("multipart", "signed");
    if(pTop!=NULL) { //ꂽ[
        mode = CGnuPGModule::Verify;
    }
    else { //Í(PGP/MIME)ꂽ[?
        pTop = item.FindCMIMEMessage("multipart", "encrypted");
    }

    if(pTop!=NULL) { //(PGP/MIME)ꂽC܂͈Í(PGP/MIME)ꂽ[
        ///ÍꂽbZ[Wo
        if((GetMIMEMessage(pTop, mode, ascPath, msgPath))==false) {
            ErrorMessage(hWnd, IDS_GPG_ERROR);
            RemoveFiles(ascPath); //Öׂ̌n
            return;
        }
        //gpg
        g_Info.m_PassPhrase = "";
        if(mode==CGnuPGModule::Verify) { //
            ExecGPG(hWnd, lParam, mode, ascPath.c_str(), msgPath.c_str());
        }
        else if(mode==CGnuPGModule::Decript) { //
            if((ExecGPG(hWnd, lParam, mode, ascPath.c_str(), msgPath.c_str()))==true) {
                char* lpArea = FileToString(msgPath);
                if (lpArea!=NULL) {
                    CMIMEMessage itemDecrypt;
                    itemDecrypt.FromString(lpArea);
                    g_Info.m_BkApi.Free(lpArea);
                    pTop->OverWrite(itemDecrypt);
                    lpArea = item.ToString();
                    //g_Info.m_BkApi.SetText(-2, lpArea); // for debug
                    g_Info.m_BkApi.SetSource("TEMP", lpArea);
                    g_Info.m_BkApi.Free(lpArea);
                }
            }
        }
        else { //J̃C|[g?
            ExecGPG(hWnd, lParam, mode, ascPath.c_str(), NULL);
        }
        //n
        g_Info.m_PassPhrase = "";
        RemoveFiles(ascPath);
        RemoveFiles(msgPath);
    }
    else { // (ł珐EÍĂ邩Ȃ)
        char szMimeType[80];
        char* lpData = g_Info.m_BkApi.GetText(szMimeType, 80);
        char* lpStr;
        if(strncmp(lpData, "-----BEGIN PGP ", 15) == 0) { //܂͈ÍĂ?
            lpStr = lpData;
        }
        else { //܂͈ÍĂ镔?
            lpStr = strstr(lpData, "\n-----BEGIN PGP ");
            if(lpStr==NULL) {
                ErrorMessage(hWnd, IDS_GPG_ERROR);
                g_Info.m_BkApi.Free(lpData);
                return;
            }
            lpStr++;
        }
        char szCharSet[80];
        g_Info.m_BkApi.GetCharSet(NULL, szCharSet, 80); //eLXg̃LN^Zbg擾
        g_Info.m_PassPhrase = "";
        int count = 0;
        for(;;) {
            //PGPubN擾
            char* lpNext = GetMessage(lpStr, mode, ascPath, szCharSet);
            if(lpNext==NULL) { //bZ[WȂ
                RemoveFiles(ascPath); //Öׂ̌n
                break;
            }
            //gpg
            bool rtn;
            if(mode==CGnuPGModule::Verify) { //
                rtn = ExecGPG(hWnd, lParam, mode, ascPath.c_str(), NULL);
            }
            else if(mode==CGnuPGModule::Decript) { //
                rtn = ExecGPG(hWnd, lParam, mode, ascPath.c_str(), msgPath.c_str());
                if(rtn==true) {
                    char* lpArea = FileToString(msgPath);
                    if (lpArea!=NULL) {
                        if (stricmp(szCharSet, "ISO-2022-JP") == 0) {
                            char* lpSJIS = g_Info.m_BkApi.ISO_2022_JP(lpArea, FALSE);
                            g_Info.m_BkApi.SetText(-2, lpSJIS);
                            g_Info.m_BkApi.Free(lpSJIS);
                        }
                        else {
                            g_Info.m_BkApi.SetText(-2, lpArea);
                        }
                        g_Info.m_BkApi.Free(lpArea);
                    }
                }
            }
            else { //J̃C|[g?
                rtn = ExecGPG(hWnd, lParam, mode, ascPath.c_str(), NULL);
            }
            //n
            RemoveFiles(ascPath);
            RemoveFiles(msgPath);
            count++;
            //㏈
            if(rtn==false) { //IȂ(~܂)
                break;
            }
            //ɂPGPubN?
            if(lpNext[0]=='\0') { //bZ[W̏I[
                break;
            }
            lpStr = strstr(lpNext, "\n-----BEGIN PGP ");
            if(lpStr==NULL) { //ȏ͂Ȃ
                break;
            }
            lpStr++;
        }
        g_Info.m_PassPhrase = "";
        g_LogFile.AppendValue("number of Decryption and Verification", count);
        if(count==0) {
            ErrorMessage(hWnd, IDS_GPG_ERROR);
        }
        g_Info.m_BkApi.Free(lpData);
    }

    return;
}

/*----------------------------------------------------------------------*/
/* Purpose        :  (j[̌Ăяo)                 */
/* Inputs         : [h                                          */
/*                  PGP/ÍubNi[t@C                  */
/*                  ؃eLXgi[t@C                            */
/* Ootput         : Ȃ                                                */
/*----------------------------------------------------------------------*/
static bool ExecGPG(HWND hWnd, LPARAM lParam, CGnuPGModule::EMODE mode, const char* ascPath, const char* msgPath)
{
    g_Info.m_UserID = ""; //[UID͋󔒂ɂĂ
    if(mode==CGnuPGModule::Decript && (g_Info.m_PassPhrase.length())==0) { //s  pX[hݒ
        CPassPhraseDialog dlg; //PassPhrase _CAO
        if((dlg.ExecDialog(hWnd, lParam, g_Info, true))==false) {
            return false;
        }
    }

    bool rtn;
    switch(mode) {
    case CGnuPGModule::Verify:
        rtn = g_Info.m_GPG.ExecVerify(ascPath, msgPath);
        break;
    case CGnuPGModule::Decript:
        rtn = g_Info.m_GPG.ExecDecrypt(ascPath, msgPath, g_Info.m_PassPhrase.c_str());
        break;
    case CGnuPGModule::ImpPubKey:
    default :
        rtn = g_Info.m_GPG.ExecImport(ascPath);
        break;
    }
    if(rtn==false) {
        ErrorMessage(hWnd, IDS_GPG_NOTPROCESSED);
        return false;
    }

    CViewDialog vdlg;
    vdlg.ExecDialog(hWnd, lParam, g_Info, g_Info.m_GPG.GetOutputMsg());

    return true;
}

/*----------------------------------------------------------------------*/
/* Purpose        : ÍbZ[W(PGP/MIME)̎o                */
/* Inputs         : [bZ[W (Top)                              */
/*                  [h                                          */
/*                  PGP/ÍubNi[t@C                  */
/*                  ؃eLXgi[t@C                            */
/* Ootput         : Boolearn                                            */
/*----------------------------------------------------------------------*/
static bool GetMIMEMessage(CMIMEMessage* pTop, CGnuPGModule::EMODE mode, string& ascPath, string& msgPath)
{
    if(pTop==NULL) {
        return false;
    }

    if(mode==CGnuPGModule::Verify) { //(PGP/MIME)ꂽ[Ƃď
    //p[gT
        CMIMEMessage* pSign = pTop->FindCMIMEMessage("application", "pgp-signature");
        if(pSign==NULL) { //p[gȂ
            g_LogFile.AppendMessage("CMIMEMessage::FindCMIMEMessage(): p[g܂ł");
            return false;
        }
        //p[gi[
        ofstream ascFile(ascPath.c_str(), ios_base::binary);
        if((ascFile.is_open())==false) {
            g_LogFile.AppendValue("t@CI[vG[", ascPath);
            return false;
        }
        char* lpSign = pSign->ToString();
        char* lpPGP = strstr(lpSign, "-----BEGIN PGP "); //PGP(?)ubNi[
        if (lpPGP==NULL) {
            g_LogFile.AppendMessage("PGPubN܂ł");
            g_Info.m_BkApi.Free(lpSign);
            return false;
        }
        ascFile << lpPGP;
        ascFile.close();
        g_Info.m_BkApi.Free(lpSign);
    //폐p[gT
        CMIMEMessage* pContent = pTop->GetChild();
        while (stricmp(pContent->GetSubType().c_str(), "pgp-signature") == 0 && pContent) {
            pContent = pContent->GetNext();
        }
        if(pContent==NULL) { //폐p[gȂ
            g_LogFile.AppendMessage("폐p[g܂ł");
            return false;
        }
        //폐p[gi[
        ofstream msgFile(msgPath.c_str(), ios_base::binary);
        if((msgFile.is_open())==false) {
            g_LogFile.AppendValue("t@CI[vG[", msgPath);
            return false;
        }
        char* lpBody = pContent->ToString();
        msgFile << lpBody;
        msgFile.close();
        g_Info.m_BkApi.Free(lpBody);
    }
    else { //()Í(PGP/MIME)ꂽ[
    //Íꂽp[gT
        CMIMEMessage* pContent = pTop->FindCMIMEMessage("application", "octet-stream");
        if(pContent==NULL) { //Íꂽp[gȂ
            g_LogFile.AppendMessage("Íꂽp[g܂ł");
            return false;
        }
        //ÍꂽubNi[
        ofstream ascFile(ascPath.c_str(), ios_base::binary);
        if((ascFile.is_open())==false) {
            g_LogFile.AppendValue("t@CI[vG[", ascPath);
            return false;
        }
        char* lpContent = pContent->ToString();
        if(lpContent==NULL) {
            g_LogFile.AppendMessage("Íꂽp[g܂ł");
            return false;
        }
        char* lpPGP = strstr(lpContent, "-----BEGIN PGP ");
        if(lpPGP==NULL) {
            g_LogFile.AppendMessage("ÍꂽubN܂ł");
            g_Info.m_BkApi.Free(lpContent);
            return false;
        }
        ascFile << lpPGP;
        ascFile.close();
        g_Info.m_BkApi.Free(lpContent);

    }

    return true;
}

/*----------------------------------------------------------------------*/
/* Purpose        : ÍbZ[W̎o                          */
/* Inputs         : [bZ[W ({)                             */
/*                  [h(Out)                                     */
/*                  PGP/ÍubNi[t@C                  */
/*                  LN^Zbg                                    */
/* Ootput         : ̃bZ[W                                      */
/*----------------------------------------------------------------------*/
static char* GetMessage(char* lpStr, CGnuPGModule::EMODE& mode, string& ascPath, char* szCharSet)
{
    ///ÍubN̎ނ𒲂ׂ
    if(strncmp(lpStr, "-----BEGIN PGP PUBLIC KEY BLOCK-----", 36) == 0) { //J
        mode = CGnuPGModule::ImpPubKey;
    }
    else if(strncmp(lpStr, "-----BEGIN PGP SIGNED MESSAGE-----",34) == 0) { //
        mode = CGnuPGModule::Verify;
    }
    else {
        mode = CGnuPGModule::Decript;
    }

    //PGPubN̏IT
    char* lpEnd = strstr(lpStr, "\n-----END PGP ");
    if(lpEnd==NULL) { //I̕Ȃ
        g_LogFile.AppendMessage("sSȃubN");
        return NULL;
    }
    //sT
    lpEnd++;
    char* lpTmp = strchr(lpEnd,'\n');
    if(lpTmp!=NULL) {
        lpEnd = lpTmp;
    }
    else {
        lpEnd = strchr(lpEnd, '\0');
    }

    //PGPubNi[
    ofstream ascFile(ascPath.c_str(), ios_base::binary);
    if((ascFile.is_open())==false) {
        //ErrorMessage(hWnd, IDS_GPG_FATALERROR);
        g_LogFile.AppendValue("t@CI[vG[", ascPath);
        return NULL;
    }
    int nLen = lpEnd - lpStr;
    if(stricmp(szCharSet, "ISO-2022-JP") == 0 || (szCharSet[0] == '\0' && GetACP() == 932)) { //{
        char* lpTemp = new char[nLen + 4]; //ɍ͂Ȃ?
        strncpy(lpTemp, lpStr, nLen);
        lpTemp[nLen] = '\0';
        char* lpJIS = g_Info.m_BkApi.ISO_2022_JP(lpTemp, TRUE); //JISɕϊ
        delete [] lpTemp;
        ascFile << lpJIS;
        g_Info.m_BkApi.Free(lpJIS);
    }
    else {
        ascFile << lpStr;
    }
    ascFile.close();

    return lpEnd;
}

/* Copyright (C) Yasuhiro ARAKAWA  **************************************/
